<script>
function captureImage() {
    const snapshotURL = "http://192.168.31.67:5000/snapshot?" + new Date().getTime();
    const startTime = performance.now();

    fetch(snapshotURL)
        .then(response => {
            if (!response.ok) throw new Error("Gagal mengakses snapshot.");
            return response.blob();
        })
        .then(blob => {
            const reader = new FileReader();
            reader.onloadend = function () {
                const dataURL = reader.result;
                const endTime = performance.now();
                const delayMs = Math.round(endTime - startTime);

                if (!dataURL.startsWith("data:image")) {
                    document.getElementById('status').innerText = "Data gambar tidak valid.";
                    return;
                }

                const formData = new URLSearchParams();
                formData.append("image", dataURL);
                formData.append("delay", delayMs);

                fetch('gambar/save_image.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: formData.toString()
                })
                .then(res => res.text())
                .then(msg => {
                    document.getElementById('status').innerText = msg + " (Delay: " + delayMs + " ms)";
                })
                .catch(err => {
                    console.error('Gagal simpan gambar:', err);
                    document.getElementById('status').innerText = 'Gagal menyimpan gambar.';
                });
            };

            reader.readAsDataURL(blob);
        })
        .catch(error => {
            console.error('Gagal mengambil snapshot:', error);
            document.getElementById('status').innerText = 'Gagal mengambil gambar.';
        });
}

// Fungsi untuk toggle menu hamburger
function toggleMenu() {
    const menu = document.getElementById("hamburgerMenu");
    menu.classList.toggle("show");
}


</script>

