<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: auth.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kamera Pengawas Rumah</title>
    <link rel="stylesheet" href="css/style.css">
    <script src="js/script.js" defer></script>
</head>
<body>

<!-- ✅ Tambahkan Hamburger Menu -->
<div class="hamburger-wrapper">
    <div class="hamburger-icon" onclick="toggleMenu()">☰</div>
    <div class="hamburger-menu" id="hamburgerMenu">
        <a href="history.php">Riwayat Login & Delay</a>
        <a href="about.php">About Us</a>
        <a href="logout.php">Keluar</a>
    </div>
</div>



<div class="container">
    <h2>Live Kamera</h2>
    <img class="video-feed" id="videoFeed" src="http://192.168.236.67:5000/video_feed" alt="Feed Kamera">
    <br>
    <button onclick="captureImage()">Ambil Gambar</button>
    <p id="status"></p>

    <!-- Tombol tambahan Snapshot Manual -->
    <h3>Snapshot Manual dari Kamera</h3>
    <button onclick="ambilSnapshot()">Ambil Snapshot Manual</button><br><br>
    <img id="snapshot" width="400" alt="Snapshot Manual" />
</div>

<script>
// ✅ Fungsi untuk hamburger menu
function toggleMenu() {
    const menu = document.getElementById("hamburgerMenu");
    menu.classList.toggle("show");
}

// ✅ Fungsi Snapshot Manual
function ambilSnapshot() {
    const snapshotImg = document.getElementById("snapshot");
    const snapshotURL = "http://192.168.236.67:5000/snapshot?" + new Date().getTime(); // Hindari cache

    fetch(snapshotURL)
        .then(response => {
            if (!response.ok) throw new Error("Gagal mengakses snapshot.");
            return response.blob();
        })
        .then(blob => {
            const objectURL = URL.createObjectURL(blob);
            snapshotImg.src = objectURL;
        })
        .catch(error => {
            console.error("Gagal ambil snapshot:", error);
            alert("Tidak bisa mengambil snapshot. Pastikan Flask di Raspberry Pi aktif dan endpoint /snapshot tersedia.");
        });
}
</script>

</body>
</html>

