<?php
session_start();
include "db.php";

$msg = "";
$show_register = isset($_GET['register']); // Cek mode register

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $is_register = isset($_POST['register']);

    if ($is_register) {
        // Proses register
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("INSERT INTO users (username, password) VALUES (?, ?)");
        $stmt->bind_param("ss", $username, $hashed);
        if ($stmt->execute()) {
            $msg = "Registrasi berhasil! Silakan login.";
            $show_register = false;
        } else {
            $msg = "Username sudah digunakan.";
            $show_register = true;
        }
    } else {
        // Proses login
        $stmt = $conn->prepare("SELECT * FROM users WHERE username=?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($row = $result->fetch_assoc()) {
            if (password_verify($password, $row['password'])) {
                $_SESSION['user'] = $username;

                // Catat ke login_history
                $ip = $_SERVER['REMOTE_ADDR'];
                $agent = $_SERVER['HTTP_USER_AGENT'];
                $log = $conn->prepare("INSERT INTO login_history (username, ip_address, user_agent) VALUES (?, ?, ?)");
                $log->bind_param("sss", $username, $ip, $agent);
                $log->execute();

                header("Location: index.php");
                exit;
            }
        }
        $msg = "Login gagal. Cek username dan password.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title><?= $show_register ? 'Daftar Akun' : 'Login' ?> - Pengawas Rumah</title>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="css/style.css">
</head>
<body class="auth-page">
    <div class="container auth-box">
        <h2><?= $show_register ? 'Daftar Akun Baru' : 'Login Pengguna' ?></h2>
        <form method="POST">
            <input type="text" name="username" placeholder="Username" required><br>
            <input type="password" name="password" placeholder="Password" required><br>
            <?php if ($show_register): ?>
                <input type="hidden" name="register" value="1">
            <?php endif; ?>
            <button type="submit"><?= $show_register ? 'Daftar' : 'Login' ?></button>
        </form>

        <p>
            <?php if ($show_register): ?>
                Sudah punya akun? <a href="login.php">Login di sini</a>
            <?php else: ?>
                Belum punya akun? <a href="login.php?register=1">Daftar di sini</a>
            <?php endif; ?>
        </p>

        <?php if ($msg): ?>
            <p class="msg"><?= $msg ?></p>
        <?php endif; ?>
    </div>
</body>
</html>

